#!/bin/sh
srcdir="/home/nemo/gapps-kk-20140606/system/priv-app"
destdir="/opt/alien/system/priv-app/"
deletedir="/home/nemo/deleted/"
playstore="/home/nemo/playstore/playstore.apk"

user=`whoami`

if [ "$user" != "root" ]; then
	echo This script requires root privileges. Please try again with devel-su.
	exit 0;
fi

echo This script requires that you have done following:
echo 1: downloaded gapps-kk-20140606 from https://www.androidfilehost.com/?fid=95832962473395379 and extracted it to /home/nemo/gapps-kk-20140606
echo 2: downloaded 7.3.25 play store and extracted it as $playstore
echo -n 'Do you want to continue? [Y/N] '
read answer

reinstall () {
	echo 1: Stopping aliendalvik
	systemctl stop aliendalvik
	systemctl mask aliendalvik

	echo 2: Replacing Play Store with a compatible one from file $playstore
	chattr -i /home/.android/data/app//incoming/com.android.vending.apk
	rm /home/.android/data/app//incoming/com.android.vending.apk
	chattr -i /data/app/com.android.vending-2.apk
	rm -f /data/app/com.android.vending-2.apk
	cp -a $playstore /data/app/com.android.vending-2.apk

	echo 3: Copying files from $srcdir to $destdir
	cp -a $srcdir/GmsCore.apk $destdir
	cp -a $srcdir/GoogleLoginService.apk $destdir
	cp -a $srcdir/GoogleServicesFramework.apk $destdir
	cp -a $srcdir/Phonesky.apk $destdir

	echo 4: Setting up rights
	chmod 644 $srcdir/GmsCore.apk
	chmod 644 $srcdir/GoogleLoginService.apk
	chmod 644 $srcdir/GoogleServicesFramework.apk
	chmod 644 $srcdir/Phonesky.apk

	echo 5: Starting aliendalvik
	systemctl unmask aliendalvik
	systemctl start aliendalvik

	echo 6: Installing Play Store. Please check the latest download enabled version from http://www.apkmirror.com/apk/google-inc/google-play-store/google-play-store-7-3-25-release/
	apkd-install $playstore

	echo 7: Preventing Play Store from updating itself
	touch /data/app/com.android.vending-2.apk
	chattr +i /data/app/com.android.vending-2.apk

	echo 8: Finished - remember to finish Play Store install in your device.
}

sign_out () {
	echo Skipping and quitting, bb.
}

case "$answer" in
	Y|y)
		reinstall
		;;
	N|n)
		sign_out
		;;
esac

exit 0;
